/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gradle.util.internal.ZipSlip;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Download;
import org.gradle.wrapper.ExclusiveFileAccessManager;
import org.gradle.wrapper.IDownload;
import org.gradle.wrapper.Logger;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;

public class Install {
    public static final String DEFAULT_DISTRIBUTION_PATH = "wrapper/dists";
    private final Logger logger;
    private final IDownload download;
    private final PathAssembler pathAssembler;
    private final ExclusiveFileAccessManager exclusiveFileAccessManager = new ExclusiveFileAccessManager(120000, 200);

    public Install(Logger logger, IDownload download, PathAssembler pathAssembler) {
        this.logger = logger;
        this.download = download;
        this.pathAssembler = pathAssembler;
    }

    public File createDist(final WrapperConfiguration configuration) throws Exception {
        final URI distributionUrl = configuration.getDistribution();
        final String distributionSha256Sum = configuration.getDistributionSha256Sum();
        PathAssembler.LocalDistribution localDistribution = this.pathAssembler.getDistribution(configuration);
        final File distDir = localDistribution.getDistributionDir();
        final File localZipFile = localDistribution.getZipFile();
        return this.exclusiveFileAccessManager.access(localZipFile, new Callable<File>(){

            @Override
            public File call() throws Exception {
                File markerFile = new File(localZipFile.getParentFile(), localZipFile.getName() + ".ok");
                if (distDir.isDirectory() && markerFile.isFile()) {
                    InstallCheck installCheck = Install.this.verifyDistributionRoot(distDir, distDir.getAbsolutePath());
                    if (installCheck.isVerified()) {
                        return installCheck.gradleHome;
                    }
                    System.err.println(installCheck.failureMessage);
                    markerFile.delete();
                }
                boolean needsDownload = !localZipFile.isFile();
                URI safeDistributionUrl = Download.safeUri(distributionUrl);
                if (needsDownload) {
                    File tmpZipFile = new File(localZipFile.getParentFile(), localZipFile.getName() + ".part");
                    tmpZipFile.delete();
                    Install.this.logger.log("Downloading " + safeDistributionUrl);
                    Install.this.download.download(distributionUrl, tmpZipFile);
                    tmpZipFile.renameTo(localZipFile);
                }
                List topLevelDirs = Install.this.listDirs(distDir);
                for (File dir : topLevelDirs) {
                    Install.this.logger.log("Deleting directory " + dir.getAbsolutePath());
                    Install.this.deleteDir(dir);
                }
                Install.this.verifyDownloadChecksum(configuration.getDistribution().toString(), localZipFile, distributionSha256Sum);
                try {
                    Install.this.unzip(localZipFile, distDir);
                }
                catch (IOException e) {
                    Install.this.logger.log("Could not unzip " + localZipFile.getAbsolutePath() + " to " + distDir.getAbsolutePath() + ".");
                    Install.this.logger.log("Reason: " + e.getMessage());
                    throw e;
                }
                InstallCheck installCheck = Install.this.verifyDistributionRoot(distDir, safeDistributionUrl.toString());
                if (installCheck.isVerified()) {
                    Install.this.setExecutablePermissions(installCheck.gradleHome);
                    markerFile.createNewFile();
                    localZipFile.delete();
                    return installCheck.gradleHome;
                }
                throw new RuntimeException(installCheck.failureMessage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateSha256Sum(File file) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (FileInputStream fis = new FileInputStream(file);){
            int n = 0;
            byte[] buffer = new byte[4096];
            while (n != -1) {
                n = ((InputStream)fis).read(buffer);
                if (n <= 0) continue;
                md.update(buffer, 0, n);
            }
        }
        byte[] byteData = md.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < byteData.length; ++i) {
            String hex = Integer.toHexString(0xFF & byteData[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private InstallCheck verifyDistributionRoot(File distDir, String distributionDescription) {
        List<File> dirs = this.listDirs(distDir);
        if (dirs.isEmpty()) {
            return InstallCheck.failure(String.format("Gradle distribution '%s' does not contain any directories. Expected to find exactly 1 directory.", distributionDescription));
        }
        if (dirs.size() != 1) {
            return InstallCheck.failure(String.format("Gradle distribution '%s' contains too many directories. Expected to find exactly 1 directory.", distributionDescription));
        }
        File gradleHome = dirs.get(0);
        if (BootstrapMainStarter.findLauncherJar(gradleHome) == null) {
            return InstallCheck.failure(String.format("Gradle distribution '%s' does not appear to contain a Gradle distribution.", distributionDescription));
        }
        return InstallCheck.success(gradleHome);
    }

    private void verifyDownloadChecksum(String sourceUrl, File localZipFile, String expectedSum) throws Exception {
        String actualSum;
        if (expectedSum != null && !expectedSum.equals(actualSum = this.calculateSha256Sum(localZipFile))) {
            localZipFile.delete();
            String message = String.format("Verification of Gradle distribution failed!%n%nYour Gradle distribution may have been tampered with.%nConfirm that the 'distributionSha256Sum' property in your gradle-wrapper.properties file is correct and you are downloading the wrapper from a trusted source.%n%n Distribution Url: %s%nDownload Location: %s%nExpected checksum: '%s'%n  Actual checksum: '%s'%n", sourceUrl, localZipFile.getAbsolutePath(), expectedSum, actualSum);
            throw new RuntimeException(message);
        }
    }

    private List<File> listDirs(File distDir) {
        File[] files;
        ArrayList<File> dirs = new ArrayList<File>();
        if (distDir.exists() && (files = distDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                dirs.add(file);
            }
        }
        return dirs;
    }

    private void setExecutablePermissions(File gradleHome) {
        if (this.isWindows()) {
            return;
        }
        File gradleCommand = new File(gradleHome, "bin/gradle");
        String errorMessage = null;
        try {
            ProcessBuilder pb = new ProcessBuilder("chmod", "755", gradleCommand.getCanonicalPath());
            Process p = pb.start();
            if (p.waitFor() != 0) {
                String line;
                BufferedReader is = new BufferedReader(new InputStreamReader(p.getInputStream()));
                Formatter stdout = new Formatter();
                while ((line = is.readLine()) != null) {
                    stdout.format("%s%n", line);
                }
                errorMessage = stdout.toString();
            }
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            errorMessage = e.getMessage();
        }
        if (errorMessage != null) {
            this.logger.log("Could not set executable permissions for: " + gradleCommand.getAbsolutePath());
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.contains("windows");
    }

    private boolean deleteDir(File dir) {
        String[] children;
        if (dir.isDirectory() && (children = dir.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(File zip, File dest) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File destFile = new File(dest, ZipSlip.safeZipEntryName(entry.getName()));
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(destFile));){
                    this.copyInputStream(zipFile.getInputStream(entry), outputStream);
                }
            }
        }
    }

    private void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    private static class InstallCheck {
        private final File gradleHome;
        private final String failureMessage;

        private static InstallCheck failure(String message) {
            return new InstallCheck(null, message);
        }

        private static InstallCheck success(File gradleHome) {
            return new InstallCheck(gradleHome, null);
        }

        private InstallCheck(File gradleHome, String failureMessage) {
            this.gradleHome = gradleHome;
            this.failureMessage = failureMessage;
        }

        private boolean isVerified() {
            return this.gradleHome != null;
        }
    }
}

